tags:: #on/breathing 
people:: [[Wim Hof]]

# Exploring Wim Hof's Breath Manipulation (kit)
This is an interesting topic and I don't have definitive answers—I hope to learn more from the burgeoning research, but here's my long take...

## PART 1
Before holding my breath, I forcefully breath in more than I breath out for around 50 breaths (sort of like hyperventilating). O2 levels increase. CO2 levels decrease. pH levels increase (and surprisingly stay higher than what’s normal even after breath-holding, which should negate a lot of the breath-holding worries, since I believe they are associated with pH drops.

O2:CO2 Ratio & pH Levels:
- A normal ratio is 4:1 & pH: 7.40
- During hyperventilation, the ratio goes up to 11:1 & pH: 7.70
- During hypoventilation, the ratio goes down to 1:1 & pH: 7.50

Interesting note: Even after breath-holding, pH levels stay surprisingly higher than normal, which should negate a lot of the breath-holding worries, since I believe the detriments that are talked about are always associated with drops in pH. Hence, if pH stays above normal, all should be good. I’d love to get some expert opinions on this.
* [Research Link](http://www.pnas.org/content/111/20/7379.full)

Lactate Levels:
- A normal range is 0.5 - 1.5 mmol/L. The test subject’s baseline was 0.70.
- During hyperventilation, it only increased to 1.15 mmol/L.
- During hypoventilation, it lowered to 0.90 mmol/L.

For comparison a 15-45 second sprint shows lactate levels rising way up to 8-15 mmol/L. So, there is no worry for the minuscule rise in lactate levels from hyper-hypoventilation.
* [Research Link](http://www.ncbi.nlm.nih.gov/pubmed/2007391)

### Benefit # 1: POSITIVE HORMONAL RESPONSE AND A (SUPPOSED) INCREASED IMMUNE SYSTEM.
This act stimulates the release of adrenaline and noradrenaline (just like taking a cold shower, which also forces us to hyperventilate a bit), and has been shown to benefit the immune system.

### Benefit # 2: MINDFULNESS
Both conscious "over-breathing" and the conscious breath-holding act as a fast and simple form of mindfulness for me, getting me out of racing thoughts in the prefrontal cortex, and—due to the hormonal release—allowing my brain stem and more primitive parts of the brain (such as the pituitary gland) to activate without invoking worry and stress (I admit things get unclear for me here, so I'd like to hear more on this). Regardless, I’m more calm, centered, and clear-minded afterwards.

### Benefit # 3: EUPHORIC FEELING
Breathing in excess O2 leads to tingling fingers and lightheadedness. It also creates a slightly euphoric feeling. Is that weird?

## PART 2
Then after elevating my O2 levels, that’s when I hold my breath, which I imagine completely moves the O2:CO2 ratio in the opposite relationship — like a seesaw. And in the process, it leads to:

### Benefit # 4: WILLPOWER BOOST
It gives a sense of control. And my belief is that a SENSE of control is a main factor in willpower and happiness. (Whether or not we really have any real control is a separate debate.) Since this odd activity increases my sense of control, it increases my sense of happiness.

### Benefit # 5: ANTI-FRAGILITY
Stressing the mind and body (safely) leads to the overcompensation effect. That’s why we adapt to heavy weights by getting stronger (to throw out a common example).

## Major Concern
Does this pattern of Hyperventilation/Retention cause any harm? There are a few studies covering Wim Hof and his method that show clear results (see below), but much more research is needed.

Anybody have other takes, insights, research, commentary, or suggestions on this?

Research Link [:](http://www.pnas.org/content/111/20/7379.full) [http://www.pnas.org/content/111/20/7379.full](http://www.pnas.org/content/111/20/7379.full)

---

*Note on Lactate Levels*
Lactic acid is a product of cell metabolism that can accumulate when cells lack sufficient oxygen (hypoxia) and must turn to a less efficient means of energy production, or when a condition causes excess production or impaired clearance of lactate.

Depending on pH, it is sometimes present in the form of lactic acid. However, with the neutral pH maintained by the body, most lactic acid will be present in the blood as lactate.

---

- Back Matter
	- dates:: 2015-12-03

---